# রমযান বাড়ি — MySQL cPanel সেটআপ গাইড
## ধাপে ধাপে সম্পূর্ণ নির্দেশিকা

---

## 📁 ফাইল তালিকা
আপনাকে এই ফাইলগুলো upload করতে হবে:

| ফাইল | কাজ |
|------|-----|
| `api.php` | Backend API — সব data এখান থেকে যাবে |
| `ramadan-bari-mysql.html` | Viewer — সবাই দেখবে |
| `ramadan-admin-mysql.html` | Admin — আপনি manage করবেন |
| `ramadan_db.sql` | Database schema + default data |

---

## ধাপ ১ — Database তৈরি করুন (phpMyAdmin)

1. **cPanel** এ লগইন করুন
2. **phpMyAdmin** খুলুন
3. উপরে **"New"** বা **"নতুন"** ক্লিক করুন
4. Database নাম দিন: `ramadan_db`
5. Collation: **utf8mb4_unicode_ci** বেছে নিন
6. **"Create"** ক্লিক করুন

### SQL Import:
1. বামদিকে `ramadan_db` ক্লিক করুন
2. উপরে **"Import"** ট্যাবে যান
3. **"Choose File"** — `ramadan_db.sql` select করুন
4. **"Go"** বা **"Import"** ক্লিক করুন
5. সবুজ "Import successful" দেখলে হয়ে গেছে ✅

---

## ধাপ ২ — Database User তৈরি করুন

cPanel → **MySQL Databases** → এ যান:

1. **"Add New User"** তে:
   - Username: `ramadan_user`
   - Password: শক্তিশালী পাসওয়ার্ড দিন

2. **"Add User to Database"** তে:
   - User: `ramadan_user`
   - Database: `ramadan_db`
   - Privileges: **ALL PRIVILEGES** ✅
   - **"Make Changes"** ক্লিক করুন

> ⚠️ **মনে রাখুন:** আপনার cPanel username সাধারণত prefix হিসেবে যোগ হয়।
> যেমন: আপনার cPanel user যদি `mysite` হয়, তাহলে:
> - Database: `mysite_ramadan_db`
> - User: `mysite_ramadan_user`

---

## ধাপ ৩ — api.php Configure করুন

`api.php` ফাইলটি text editor (Notepad, VS Code) দিয়ে খুলুন।
নিচের অংশটি খুঁজুন এবং পরিবর্তন করুন:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'ramadan_db');      // ← আপনার database নাম
define('DB_USER', 'your_db_user');    // ← আপনার database username
define('DB_PASS', 'your_db_password');// ← আপনার database password
```

**উদাহরণ (যদি cPanel user = mysite):**
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'mysite_ramadan_db');
define('DB_USER', 'mysite_ramadan_user');
define('DB_PASS', 'MySecurePass123!');
```

ফাইল save করুন।

---

## ধাপ ৪ — ফাইল Upload করুন

cPanel → **File Manager** → `public_html` ফোল্ডারে যান।

একটি নতুন ফোল্ডার তৈরি করুন: `ramadan`

এই ফাইলগুলো upload করুন:
```
public_html/
└── ramadan/
    ├── api.php                   ← Backend
    ├── ramadan-bari-mysql.html   ← Viewer
    └── ramadan-admin-mysql.html  ← Admin
```

> `ramadan_db.sql` আর upload করতে হবে না — phpMyAdmin এ already import করা হয়েছে।

---

## ধাপ ৫ — ব্যবহার শুরু করুন

**Viewer URL (সবাই দেখবে):**
```
https://yourdomain.com/ramadan/ramadan-bari-mysql.html
```

**Admin URL (শুধু আপনি):**
```
https://yourdomain.com/ramadan/ramadan-admin-mysql.html
```

**API URL (দুই ফাইলেই এটা দিতে হবে):**
```
https://yourdomain.com/ramadan/api.php
```

---

## ধাপ ৬ — Admin Panel Setup

1. `ramadan-admin-mysql.html` খুলুন
2. উপরের ব্যানারে **API URL** দিন:
   `https://yourdomain.com/ramadan/api.php`
3. **"সংরক্ষণ করুন"** ক্লিক করুন
4. Login করুন:
   - Username: `admin`
   - Password: `ramadan2026`
5. Settings → পাসওয়ার্ড পরিবর্তন করুন!

---

## ধাপ ৭ — Viewer Setup

1. `ramadan-bari-mysql.html` খুলুন
2. উপরের ব্যানারে **API URL** দিন
3. **"সংযোগ করুন"** ক্লিক করুন
4. MySQL থেকে data load হবে

---

## 🔄 কিভাবে কাজ করে

```
Admin Panel → PHP API → MySQL Database
                ↕
Viewer Panel ← PHP API ← MySQL Database
```

Admin যখন কিছু সেভ করে → MySQL আপডেট হয় → Viewer পরবর্তী refresh এ নতুন data দেখায় (auto-refresh: ৫ মিনিট)।

---

## ❓ সাধারণ সমস্যা

| সমস্যা | সমাধান |
|--------|--------|
| "Database connection failed" | DB credentials চেক করুন। cPanel prefix দেখুন |
| Login কাজ করছে না | API URL ঠিক আছে কিনা দেখুন |
| Data দেখাচ্ছে না | Browser console (F12) এ error দেখুন |
| "Access denied" | MySQL user এর permissions চেক করুন |
| localhost কাজ করছে না | Hosting provider কে জিজ্ঞেস করুন host নাম |

---

## 🔒 নিরাপত্তা পরামর্শ

- ✅ Admin এর default পাসওয়ার্ড অবশ্যই পরিবর্তন করুন
- ✅ Admin HTML ফাইলের URL কাউকে share করবেন না
- ✅ HTTPS ব্যবহার করুন (বেশিরভাগ hosting এ free)
- ✅ Database password শক্তিশালী রাখুন

---

**সাহায্য লাগলে:**  আপনার cPanel hosting provider এর support এ যোগাযোগ করুন এবং MySQL database নাম ও user নাম জিজ্ঞেস করুন।
